//
//  JailbreakService.swift
//  Demo iOS
//
//  Created by coreoz on 15/07/2022.
//

import Foundation
import UIKit

class JailbreakService {
    
    static func isDeviceJailbroken() -> Bool {
        return
            isCydiaAvailable()
        || areJailbrokenFilesPresentInTheDirectory()
        || canEditSandboxFilesForJailbreakDetection()
        
    }
    
    private static func isCydiaAvailable() -> Bool {
        return UIApplication.shared.canOpenURL(URL(string: "cydia://")!)
    }

    private static func areJailbrokenFilesPresentInTheDirectory() -> Bool {
        let fm = FileManager.default
        return fm.fileExists(atPath: "/private/var/lib/apt") || fm.fileExists(atPath: "/Applications/Cydia.app")
    }
    
    private static func canEditSandboxFilesForJailbreakDetection() -> Bool {
        let jailBreakTestText = "Test for JailBreak"
        do {
            try jailBreakTestText.write(toFile:"/private/jailBreakTestText.txt", atomically:true, encoding:String.Encoding.utf8)
            return true
        } catch {
            return false
        }
    }
}
